/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.split;

import com.fshows.postar.request.PostarBaseReq;
import com.fshows.postar.request.share.split.detail.SubAccountTransDetail;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 子户转账(XZY046)请求
 *
 * @author wangyi
 * @version PostarSubAccountTransReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarSubAccountTransReq extends PostarBaseReq {

    /**
     * 分账功能管理员商户的600商户号
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 转账明细列表
     * 必填: 是
     */
    @NotEmpty
    private List<SubAccountTransDetail> acntSplitDetails;

    /**
     * 备注
     * 必填: 否
     */
    private String remark;

    /**
     * 三方订单号
     * 必填: 是
     */
    @NotBlank
    private String otherOrderNo;
}
