/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.split;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

/**
 * 分账结算电子回单下载(XZY037)请求
 *
 * @author wangyi
 * @version PostarSplitReceiptReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarSplitReceiptReq extends PostarBaseReq {

    /**
     * 三方订单号
     * 必填: 否
     */
    private String otherOrderNo;

    /**
     * 分账流水号
     * 必填: 否
     */
    private String tradeId;

    /**
     * 分账发起时间
     * 格式:yyyymmdd，半年内订单可不传时间
     * 必填: 否
     */
    private String tradeTime;
}
