/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.split;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 余额查询接口(XZY041)请求
 *
 * @author wangyi
 * @version PostarAcntQueryReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarAcntQueryReq extends PostarBaseReq {

    /**
     * 分账功能管理员商户的600商户号
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 600商户号
     * 商户号、客户号二选一
     * 必填: 否
     */
    private String custId;

    /**
     * 客户号
     * 商户号、客户号二选一
     * 必填: 否
     */
    private String customerId;
}
