/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.product;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 修改生效状态(XZY004)请求
 *
 * @author wangyi
 * @version PostarEffectiveStatusEditReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarEffectiveStatusEditReq extends PostarBaseReq {

    /**
     * 管理方商户号
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 生效状态
     * 1-生效 0-不生效
     * 必填: 是
     */
    @NotBlank
    private String effectiveStatus;
}
