/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.product;

import com.fshows.postar.request.PostarBaseReq;
import com.fshows.postar.request.share.product.detail.CostProductInfo;
import com.fshows.postar.request.share.product.detail.EditBasicProductInfo;
import com.fshows.postar.request.share.product.detail.MaterialProductInfo;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 编辑(XZY003)请求
 *
 * @author wangyi
 * @version PostarEditProductReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarEditProductReq extends PostarBaseReq {

    /**
     * 600主商户号
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 请求时间戳
     * 必填: 是
     */
    @NotBlank
    private String timestamp;

    /**
     * 产品基础信息
     * 必填: 是
     */
    @NotNull
    @Valid
    private EditBasicProductInfo basicProduct;

    /**
     * 产品费用信息
     * 如未修改，将原数据送回
     * 必填: 是
     */
    @NotNull
    @Valid
    private CostProductInfo costProduct;

    /**
     * 产品附件信息
     * 必填: 否
     */
    private MaterialProductInfo materialProduct;
}
