/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.product;

import com.fshows.postar.request.PostarBaseReq;
import com.fshows.postar.request.share.product.detail.InvoiceProductInfo;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 编辑上传付款凭证(XZY002)请求
 *
 * @author wangyi
 * @version PostarEditInvoiceProductReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarEditInvoiceProductReq extends PostarBaseReq {

    /**
     * 管理商户id
     * 600商户在星驿付的唯一代码
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 开票对象
     * 必填: 是
     */
    @NotNull
    @Valid
    private InvoiceProductInfo editInvoiceProductReq;
}
