/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.customer;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 查询分账客户信息(XZY021)请求
 *
 * @author wangyi
 * @version PostarQuerySplitCustomerInfoReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarQuerySplitCustomerInfoReq extends PostarBaseReq {

    /**
     * 分账功能管理600商户
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 商户编号
     * 分账商户编号，custId、customerId必须送一个优先匹配custId
     * 必填: 否
     */
    private String custId;

    /**
     * 客户编号
     * 分账接收方客户编号，custId、customerId必须送一个优先匹配custId
     * 必填: 否
     */
    private String customerId;

    /**
     * 请求时间戳
     * 格式：yyyyMMddHHmmss
     * 必填: 是
     */
    @NotBlank
    private String timestamp;
}
