/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.common;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 上传文件(XZY013)请求
 *
 * @author wangyi
 * @version PostarUploadFileReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarUploadFileReq extends PostarBaseReq {

    /**
     * 600主商户号
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 文件base64数据
     * 支持上传pdf，png格式文件（但文件需带有base64头，如：data:application/pdf;base64）
     * 必填: 是
     */
    @NotBlank
    private String fileBase64;

    /**
     * 请求时间戳
     * 格式：yyyyMMddHHmmss
     * 必填: 是
     */
    @NotBlank
    private String timestamp;
}
