/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.collect;

import com.fshows.postar.request.PostarBaseReq;
import com.fshows.postar.request.share.collect.detail.AcntCollectDetail;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 归集(XZY030)请求
 *
 * @author wangyi
 * @version PostarCollectReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarCollectReq extends PostarBaseReq {

    /**
     * 归集功能管理员商户的600商户号
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 归集明细列表
     * 必填: 是
     */
    @NotEmpty
    private List<AcntCollectDetail> acntCollectDetails;

    /**
     * 归集备注
     * 必填: 否
     */
    private String remark;

    /**
     * 归集金额来源
     * 0-订单 1-余额
     * 必填: 是
     */
    @NotBlank
    private String txAmtSource;

    /**
     * 三方订单号
     * 必填: 是
     */
    @NotBlank
    private String otherOrderNo;

    /**
     * 归集交易订单号列表
     * 归集金额来源:0-订单 时必传
     * 必填: 否
     */
    private List<String> orders;
}
