/*
 * ailike.com
 * Copyright (C) 2022-2025 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangling
 * @version PostarBindingSynchronizationReq.java, v 0.1 2025-12-09 14:29 zhangling
 */
@Data
public class PostarBindingSynchronizationReq extends PostarBaseReq {
    /**
     * 商户号。
     */
    @NotBlank
    private String custId;
    /**
     * 客户经理编号
     */
    private String manId;
    /**
     * 绑定设备SN设备编号
     */
    private String sn;
    /**
     * 时间戳
     * 必填: 是
     */
    @NotBlank
    private String timeStamp;
}