/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.trade;

import com.fshows.postar.response.PostarBizRes;
import lombok.Data;

/**
 * 预授权撤销响应
 *
 * @author Cascade
 * @version PostarPreAuthCancelRes.java, v 0.1 2025-12-08 14:45 Cascade
 */
@Data
public class PostarPreAuthCancelRes extends PostarBizRes {
    private static final long serialVersionUID = -5819273649238756123L;

    /**
     * 平台订单号
     * 撤销订单的国通平台订单号
     */
    private String orderFlowNo;

    /**
     * 原撤销第三方订单号
     */
    private String oldThreeNo;

    /**
     * 撤销金额
     * 单位：分
     */
    private String amount;

    /**
     * 订单状态
     * 16预授权撤销成功
     */
    private String orderStatus;

    /**
     * 机构号
     */
    private String agetId;

    /**
     * 商户号
     */
    private String custId;

    /**
     * 撤销时间
     */
    private String orderTime;
}
