/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.response.share.collect.detail;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 归集客户基础信息响应
 *
 * @author wangyi
 * @version CollectCustomerBaseInfoRes.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class CollectCustomerBaseInfoRes {

    /**
     * 客户名称
     */
    private String custName;

    /**
     * 客户角色
     * 0商户方，1接收方
     */
    private String customerRole;

    /**
     * 订单最大归集比例
     * 单位%，例如送1就是1%
     */
    private BigDecimal maxValue;

    /**
     * 客户标签
     */
    private String tag;

    /**
     * 客户类型
     * 0企业 1个人
     */
    private String customerType;

    /**
     * 结算类型
     * 0-对公，1-对私
     */
    private String settleType;

    /**
     * 统一社会信用码
     */
    private String usci;

    /**
     * 持卡人姓名
     */
    private String idCardName;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 联系人手机号
     */
    private String phoneNo;

    /**
     * 到账方式
     * 0直接到卡 1手工提现
     */
    private String receiptType;

    /**
     * 结算周期
     * 0:D0 1:T1 2:D1
     */
    private String settlementCycle;

    /**
     * 客户状态
     * 0未生效，1合作中，2合作终止
     */
    private String customerStatus;

    /**
     * 入网状态
     * 0-待签约 1-待审核 2-审核通过 3-审核驳回
     */
    private String incomeStatus;

    /**
     * 入网描述
     */
    private String incomeStatusMsg;

    /**
     * 邀请签约链接
     */
    private String shortUrl;
}
