/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.response.share.collect.detail;

import lombok.Data;

/**
 * 归集结算卡审核信息响应
 *
 * @author wangyi
 * @version AuthCollectSettlementRes.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class AuthCollectSettlementRes {

    /**
     * 结算卡审核状态
     * 0-待审核 1-审核驳回
     */
    private String authStatus;

    /**
     * 结算卡操作类型
     * 0-新增，1-修改，2-删除
     */
    private String operationType;

    /**
     * 银行卡号
     */
    private String cardNo;

    /**
     * 银行卡开户名
     */
    private String cardName;

    /**
     * 默认结算账户
     * 0否 1是
     */
    private String isDefault;

    /**
     * 银行缩写
     */
    private String bankNo;

    /**
     * 支行省编码
     */
    private String provinceAreaCode;

    /**
     * 支行城市编码
     */
    private String cityAreaCode;

    /**
     * 支行联行号
     */
    private String interbankNumber;
}
