/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.split.detail;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 子户转账明细
 *
 * @author wangyi
 * @version SubAccountTransDetail.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class SubAccountTransDetail {

    /**
     * 转账出款方商户号，600商户在星驿付的唯一代码
     * 必填: 否
     */
    private String outCustId;

    /**
     * 转账收款方商户号，600商户在星驿付的唯一代码
     * 必填: 否
     */
    private String inCustId;

    /**
     * 转账收款方客户号
     * 必填: 否
     */
    private String inCustomerId;

    /**
     * 转账出款方客户号
     * 必填: 否
     */
    private String outCustomerId;

    /**
     * 金额：元
     * 必填: 是
     */
    private BigDecimal txAmt;
}
