/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.product.detail;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 产品费用信息
 *
 * @author wangyi
 * @version CostProductInfo.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class CostProductInfo {

    /**
     * 年费金额
     * 单位：元
     * 必填: 是
     */
    @NotNull
    private BigDecimal costAmt;

    /**
     * 分账服务费
     * 单位：%
     * 必填: 是
     */
    @NotBlank
    private String fee;

    /**
     * 是否特殊申请
     * 0-否 1-是
     * 必填: 是
     */
    @NotBlank
    private String isSpecialApply;

    /**
     * 接口费金额
     * 单位：元
     * 必填: 是
     */
    @NotNull
    private BigDecimal isvCostAmt;

    /**
     * 接口费收取模式
     * 0-商户转账，1-免费，2-无接口模式
     * 必填: 是
     */
    @NotNull
    private Integer isvCostMode;

    /**
     * 最大客户数
     * 必填: 否
     */
    private Integer maxCustomerCount;

    /**
     * 年费收取模式
     * 0-商户转账 1-免费
     * 必填: 是
     */
    @NotNull
    private Integer splitCostMode;

    /**
     * 年费项目版本
     * 0-标准版，1-高级版，2-纯年费版，4-基础版
     * 必填: 是
     */
    @NotBlank
    private String splitCostVersion;
}
