/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.collect;

import com.fshows.postar.request.PostarBaseReq;
import com.fshows.postar.request.share.collect.detail.CollectEditInfo;
import com.fshows.postar.request.share.customer.detail.AttachmentInfo;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 编辑归集信息(XZY029)请求
 *
 * @author wangyi
 * @version PostarEditCollectInfoReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarEditCollectInfoReq extends PostarBaseReq {

    /**
     * 请求时间戳
     * 格式：yyyyMMddHHmmss
     * 必填: 是
     */
    @NotBlank
    private String timestamp;

    /**
     * 客户基础信息
     * 必填: 是
     */
    @NotNull
    private CollectEditInfo customerBaseInfo;

    /**
     * 客户附件信息
     * 必填: 否
     */
    private List<AttachmentInfo> attachmentList;
}
