/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.collect;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

/**
 * 归集结算电子回单下载(XZY038)请求
 *
 * @author wangyi
 * @version PostarCollectReceiptReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarCollectReceiptReq extends PostarBaseReq {

    /**
     * 三方订单号
     * 必填: 否
     */
    private String otherOrderNo;

    /**
     * 归集流水号
     * 必填: 否
     */
    private String tradeId;

    /**
     * 归集发起时间
     * 格式:yyyymmdd，半年内订单可不传时间
     * 必填: 否
     */
    private String tradeTime;
}
