/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.collect;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

/**
 * 归集订单查询(XZY031)请求
 *
 * @author wangyi
 * @version PostarCollectQueryReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarCollectQueryReq extends PostarBaseReq {

    /**
     * 三方订单号
     * 三方订单号和归集流水号二选一
     * 必填: 否
     */
    private String otherOrderNo;

    /**
     * 归集流水号
     * 三方订单号和归集流水号二选一
     * 必填: 否
     */
    private String tradeId;

    /**
     * 交易时间
     * 格式:yyyymmdd，半年内订单可不传时间
     * 必填: 否
     */
    private String tradeTime;
}
