/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.account;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 结算资金流水查询(XZY047)请求
 *
 * @author wangyi
 * @version PostarSettleAmtQueryReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarSettleAmtQueryReq extends PostarBaseReq {

    /**
     * 600商户号
     * 必填: 否
     */
    private String custId;

    /**
     * 转结时间
     * 格式:yyyymmdd
     * 必填: 是
     */
    @NotBlank
    private String tradeTime;

    /**
     * 查询当前页数
     * 每页最大50条数据
     * 必填: 是
     */
    @NotBlank
    private String currentPage;
}
