/*
 * ailike.com
 * Copyright (C) 2022-2025 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangling
 * @version PostarUnbindPosReq.java, v 0.1 2025-12-09 14:25 zhangling
 */
@Data
public class PostarUnbindPosReq extends PostarBaseReq {
    /**
     * 商户号。
     */
    @NotBlank
    private String custId;
    /**
     * 设备SN
     */
    private String sn;
    /**
     * 码牌链接
     */
    private String codeUrl;
    /**
     * 时间戳
     * 必填: 是
     */
    @NotBlank
    private String timeStamp;
}