package com.fshows.postar.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 请求的方式，GET / POST
 * <p>
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
public enum ApiRequestTypeEnum {
    GET("GET请求", "GET"),
    POST("POST请求", "POST");

    private String name;
    private String value;

    ApiRequestTypeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static FuStewardApiTypeEnum getByValue(String value) {
        FuStewardApiTypeEnum[] valueList = FuStewardApiTypeEnum.values();
        for (FuStewardApiTypeEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}
