/*
 * 51qbiz.id
 * Copyright (C) 2021-2023 All Rights Reserved.
 */
package com.fshows.postar.apienum;

import com.fshows.postar.contant.PostarConstant;
import com.fshows.postar.request.baseinfo.PostarActivityImageUploadReq;
import com.fshows.postar.request.baseinfo.PostarQueryFallAgetIdReq;
import com.fshows.postar.response.baseinfo.PostarActivityImageUploadRes;
import com.fshows.postar.response.baseinfo.PostarQueryFallAgetIdRes;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;

/**
 * @author Xujianwei
 * @version PostarBaseInfoApiEnum.java, v 0.1 2024-12-16 10:36 Xujianwei
 */
public enum PostarBaseInfoApiEnum implements IApiDefinition {
    QUERY_FALL_AGET_ID(
            "落地银行下级机构查询",
            "/yyfsevr/addCust/queryFallAgetId",
            PostarConstant.DEFAULT_API_VERSION,
            PostarQueryFallAgetIdReq.class,
            PostarQueryFallAgetIdRes.class
    ),
    IMAGE_UPDATE(
            "图片上传",
            "/yyfsevr/addCust/custUploadImg",
            PostarConstant.DEFAULT_API_VERSION,
            PostarActivityImageUploadReq.class,
            PostarActivityImageUploadRes.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本，默认1.0
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    PostarBaseInfoApiEnum(String name,
                          String apiSubURI,
                          String version,
                          Class requestClass,
                          Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}
