/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.trade.detail;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @author wangqilei
 * @version GoodsInfo.java, v 0.1 2024-06-05 5:58 PM wangqilei
 */
@Data
public class GoodsInfo {
    /**
     * 系统内部生成的商品唯一标识
     * (选填)
     */
    private String id;

    /**
     * 商品的正式名称
     * (必填)
     */
    private String name;

    /**
     * 商品的单位价格
     * (必填)
     */
    private String price;

    /**
     * 用户添加到购物车的商品数量
     * (必填)
     */
    private String quantity;

    /**
     * 商品所属的类别
     * (特殊必填)
     */
    private String category;

    /**
     * 与商品相关的额外信息，如优惠券类型等
     * (特殊必填)
     */
    @JSONField(name = "card_type")
    private String cardType;
}