/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author weikunpeng
 * @version PostarAnxinSignSupplementaryReq.java, v 0.1 2024-10-09 15:54 weikunpeng
 */
@Data
public class PostarAnxinSignSupplementaryReq extends PostarBaseReq {

    /**
     * 商户号
     */
    @NotBlank
    private String custId;

    /**
     * 安心签验证码
     */
    @NotBlank
    private String checkCode;

    /**
     * 时间戳
     * 格式yyyyMMddHHmmss
     */
    @NotBlank
    private String timeStamp;

}