/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;


import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhaoxumin
 * @version PostarWxPayConfigReq.java, v 0.1 2024-06-05 19:25:59 zhaoxumin
 */
@Data
public class PostarWxPayConfigReq extends PostarBaseReq {

    private static final long serialVersionUID = -3326723311744714463L;

    /**
     * 商户所在国通系统内商户号
     * (必填)
     */
    @NotBlank
    private String custId;

    /**
     * 查询报备接口查询银联微信时返回的第三方子商户号
     * (必填)
     */
    @NotBlank
    private String wxSubMercid;

    /**
     * 移动支付appid. 联系对接人员获取
     */
    @NotBlank
    private String agetAppid;

    /**
     * 支付目录
     */
    @NotBlank
    private String authPath;

    /**
     * 接口请求时间. 格式yyyyMMddHHmmss
     */
    private String timeStamp;
}