/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author weikunpeng
 * @version PostarUpdateCustAccountReq.java, v 0.1 2024-10-09 16:47 weikunpeng
 */
@Data
public class PostarUpdateCustAccountReq extends PostarBaseReq {
    /**
     * 商户号
     * 商户所在国通系统内商户号，必传字段
     */
    @NotBlank
    private String custId;

    /**
     * 结算类型
     * 01对公、02法人对私、03非法人对私。小微商户仅支持02法人对私，必传字段
     */
    @NotBlank
    private String accountType;

    /**
     * 图片时间戳
     * 基础进件板块-“商户进件上传图片”-时间戳timestamp字段，一个商户一个时间戳，必传字段
     */
    @NotBlank
    private String timestamp;

    /**
     * 结算户名（持卡人姓名）
     * 必传字段
     */
    @NotBlank
    private String accountName;

    /**
     * 结算卡号
     * 必传字段
     */
    @NotBlank
    private String accountNo;

    /**
     * 开户行(缩写)
     * 调用基础信息板块-银行信息查询/根据银行卡号获取银行信息获取，必传字段
     */
    @NotBlank
    private String bankCode;

    /**
     * 支行名称
     * 结算类型为“01对公”时必填
     */
    private String branchName;

    /**
     * 开户银行联行号
     * 结算类型为“01对公”时必填
     */
    private String bankno;

    /**
     * 结算人姓名
     * 结算类型为“03非法人对私”时必填
     */
    private String stlName;

    /**
     * 结算人身份证
     * 结算类型为“03非法人对私”时必填
     */
    private String accCredNo;

    /**
     * 结算人身份证有效期开始
     * 结算类型为“03非法人对私”时必填，格式YYYYMMDD
     */
    private String accCredStartDate;

    /**
     * 结算人身份证有效期结束
     * 结算类型为“03非法人对私”时必填，格式YYYYMMDD，永久传"长期"
     */
    private String accCredEndDate;


}