/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;


import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhaoxumin
 * @version PostarCustConfigReq.java, v 0.1 2025-11-05 10:35 zhaoxumin
 */
@Data
public class PostarCustConfigReq extends PostarBaseReq {

    private static final long serialVersionUID = 4384600462808814822L;
    /**
     * 商户所在国通系统内商户号
     * (必填)
     */
    @NotBlank
    private String custId;

    /**
     * 来源接口“开通业务查询”内，传输该值，则商户根据机构层交易参数跑批
     */
    private String paramId;

    /**
     * 来源接口“开通业务查询”内，传输该值，则商户根据机构层交易参数跑批
     */
    private String paramName;

    /**
     * 微信公众号appid
     */
    private String wxAppid;

    /**
     * 微信公众号秘钥
     */
    private String wxSecret;

    /**
     * 微信小程序appid
     */
    private String smallAppid;

    /**
     * 微信小程序秘钥
     */
    private String smallSecret;

    /**
     * 码牌前缀（交易授权地址前缀）
     */
    private String codeFrontUrl;

    /**
     * 微信渠道号
     */
    private String wxQdh;

    /**
     * 移动支付appid，联系对接人员获取，与微信渠道号一一对应
     */
    private String mAppid;

    /**
     * 支付宝appid
     */
    private String zfbAppid;

    /**
     * 授权目录1
     */
    private String authPath1;

    /**
     * 授权目录2
     */
    private String authPath2;

    /**
     * 接口请求时间. 格式yyyyMMddHHmmss
     */
    private String timeStamp;
}