/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.merchant.detail;

import lombok.Data;

import java.io.Serializable;

/**
 * @author weikunpeng
 * @version PostarIncomeNotifyData.java, v 0.1 2024-10-10 14:47 weikunpeng
 */
@Data
public class PostarIncomeNotifyData implements Serializable {
    /**
     * 商户号
     * 国通600商户号，用于接口文档内所有涉及商户号字段使用
     */
    private String CUST_ID;

    /**
     * 商户名称
     */
    private String BUS_NAME;

    /**
     * 商户手机号
     */
    private String PHONE;

    /**
     * 收单商户号
     */
    private String THIRD_NO;

    /**
     * 结算账户名
     */
    private String ACCOUNT_NAME;

    /**
     * 结算账号
     */
    private String ACCOUNT_NO;

    /**
     * 开户行
     */
    private String BANK_NAME;

    /**
     * 进件审核时间
     * 格式：yyyymmddhhmmss
     */
    private String AUTH_DATE;

    /**
     * 商户类型
     * 1.普通商户 2.小微商户
     */
    private String CUST_TYPE;

    /**
     * 所属机构号
     * 国通系统机构号
     */
    private String AGE_CUST_ID;

    /**
     * 所属机构名称
     * 国通系统机构名称
     */
    private String AGE_NAME;

    /**
     * 客户经理编号
     */
    private String MERGER_ID;

    /**
     * 客户经理名称
     */
    private String MERGER_NAME;

    /**
     * 客户经理手机号
     */
    private String MERGER_PH;

    /**
     * 审核结果
     * 空值为默认值，00审核通过；后续字段皆为审核失败
     */
    private String AUTH_RESULT;

    /**
     * 审核失败具体原因
     */
    private String NOT_THROW_REASON;

    /**
     * 签名
     */
    private String sign;
}