/*
 * 51qbiz.id
 * Copyright (C) 2021-2023 All Rights Reserved.
 */
package com.fshows.postar.request.bankactivity;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 银行补贴活动查询请求
 *
 * @author Xujianwei
 * @version PostarActSubReq.java, v 0.1 2024-11-22 16:14 Xujianwei
 */
@Data
public class PostarQueryActSubReq extends PostarBaseReq {
    private static final long serialVersionUID = -482265402250676499L;

    /**
     * 页码	不填默认1
     */
    private String page;
    /**
     * 每页数量	不填默认20
     */
    private String size;
    /**
     * 时间戳 格式yyyyMMddHHmmss
     */
    @NotNull(message = "时间戳：timeStamp不能为空")
    private String timeStamp;

}
