/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author weikunpeng
 * @version PostarAnxinSignPerson.java, v 0.1 2024-10-09 15:32 weikunpeng
 */
@Data
public class PostarAnxinSignPersonReq extends PostarBaseReq {

    /**
     * 进件机构号
     * “机构号”为FWH国通虚拟机构时，“进件机构号”必填
     */
    private String applyAgetId;

    /**
     * 登入账号（手机号）
     */
    @NotBlank
    private String custLogin;

    /**
     * 商户姓名
     */
    @NotBlank
    private String custName;

    /**
     * 商户身份证号
     */
    @NotBlank
    private String credNo;

    /**
     * 电子邮箱
     * 邮箱与手机号必填其一
     */
    private String email;

    /**
     * 商户联系手机号
     * 邮箱与手机号必填其一
     */
    private String phone;

    /**
     * 开户人姓名
     * 三要素认证
     */
    @NotBlank
    private String accountName;

    /**
     * 结算卡号
     * 三要素认证
     */
    @NotBlank
    private String accountNo;

    /**
     * 时间戳
     * 格式yyyyMMddHHmmss
     */
    @NotBlank
    private String timeStamp;

}