/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response.merchant;

import com.fshows.response.LzccbBaseResponse;
import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 图片上传 response
 *
 * @author
 * @version LzccbImpUploadRes.java, v 0.1 2024-09-10 09:31:48
 */
@Data
@ToString(callSuper = true)
public class LzccbMerchantStatusQueryRes extends LzccbBaseResponse implements Serializable {

    private static final long serialVersionUID = -5226723947638697641L;
    /**
     * 同步返回平台商户号
     */
    @NotBlank
    private String merchantNo;

    /**
     * 停用原因
     * 状态为停用时返回
     */
    private String disableReason;

    /**
     * 商户状态
     * ACTIVE-正常
     * INACTIVE-禁用
     */
    @NotBlank
    private String status;

    /**
     * CHECKED-已审核
     * CHECKING审核中
     * UNCHECK-未审核
     * REFUSE-审核拒绝
     */
    @NotBlank
    private String checkProcess;

    /**
     *
     */
    private String checkMsg;

    /**
     * CHECKED-已审核
     * CHECKING审核中
     * UNCHECK-未审核
     * REFUSE-审核拒绝
     */
    private String updateCheckProcess;

}