/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 订单查询接口 response
 *
 * @author
 * @version LzccbOrderQueryRes.java, v 0.1 2024-09-11 16:37:10
 */
@Data
public class LzccbOrderQueryRes extends LzccbBaseResponse implements Serializable {

    private static final long serialVersionUID = -2213838555161827480L;


    /**
     * 订单状态
     * (必填)
     */
    @NotBlank
    private String orderStatus;

    /**
     * 退款状态
     * (必填)
     */
    @NotBlank
    private String refundStatus;

    /**
     * 清算状态
     * (必填)
     */
    @NotBlank
    private String settlementStatus;

    /**
     * 交易模式
     * (必填)
     */
    @NotBlank
    private String trxMode;

    /**
     * 业务类型
     * (必填)
     */
    @NotBlank
    private String trxType;

    /**
     * 服务方流水
     * (特殊必填)
     */
    private String serviceNo;

    /**
     * 交易金额（如是退款订单是退款金额）
     * (必填)
     */
    @NotBlank
    private String tradeAmount;

    /**
     * 商户订单号
     * (必填)
     */
    @NotBlank
    private String merchantOrderNo;

    /**
     * 商户号
     * (必填)
     */
    @NotBlank
    private String merchantNo;

    /**
     * 平台订单号
     * (必填)
     */
    @NotBlank
    private String trxNo;

    /**
     * 对账状态 未对账，对账成功，对账失败
     * (必填)
     */
    @NotBlank
    private String reconciliationStatus;

    /**
     * 渠道交易完成时间，交易完成时必填
     * (特殊必填)
     */
    private String transCompleteTime;

    /**
     * 平台手续费，退款时为0
     * (必填)
     */
    @NotBlank
    private String platIncome;

    /**
     * 原始平台订单号，退款订单此项必填
     * (特殊必填)
     */
    private String oldTrxNo;

    /**
     * 支付渠道类型
     * (必填)
     */
    @NotBlank
    private String userAgent;

    /**
     * 终端号(POS机具号)
     * (必填)
     */
    @NotBlank
    private String terminalId;

}