/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request.merchant;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 机具报备接口 request
 *
 * @author
 * @version LzccbDeviceRegisterReq.java, v 0.1 2024-09-12 09:52:48
 */
@Data
public class LzccbMerchantAttachInfoReq implements Serializable {

    private static final long serialVersionUID = -165323278865314333L;
    /**
     * 证件资料编号
     *  attachType为
     *          BUSINESS
     *          IDCARHEAD，
     *          HOLDING,
     *          PUBLICLEGAL
     * 时必须上送，
     *
     * CONTRACTSIGNING  不传该值
     */
    @Length(max = 32, message = "attachNo长度不能超过32")
    private String attachNo;

    /**
     * 证件资料url
     */
    @NotBlank
    @Length(max = 32, message = "attachPic长度不能超过32")
    private String attachPic;

    /**
     * 证件资料类型
     * BUSINESS --营业执照
     * PUBLICLEGAL--事业单位法人证书
     * HOLDING--手持身份证照
     * IDCARDHRAD--身份证人像面
     * IDCARDNATION--身份证国徽面
     * CONTRACTSIGNING--合同签署文件 (企业商户，政府商户，事业单位必传)
     * CARDHEADSETTLE--结算账户正面照-必传
     */
    @NotBlank
    @Length(max = 32, message = "attachType长度不能超过32")
    private String attachType;

    /**
     * 有效期起始日期
     * attachType为BUSINESS IDCARDNATION，HOLDING时必须上送
     */
    @Length(max = 8, message = "beginDate长度不能超过8")
    private String beginDate;

    /**
     * 有效期结束日期
     * attachType为BUSINESS IDCARDNATION，HOLDING时必须上送
     */
    @Length(max = 8, message = "endDate长度不能超过8")
    private String endDate ;

    /**
     * 备注信息
     * attachType为IDCARDHEAD时，送身份证地址信息
     * 为BUSINESS时，送营业执照名称
     */
    @Length(max = 128, message = "legalPhone长度不能超过128")
    private String remark;

}