/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import java.io.Serializable;

/**
 * 统一下单接口 request
 *
 * @author
 * @version LzccbUnifiedOrderCreateReq.java, v 0.1 2024-09-10 09:31:48
 */
@Data
public class LzccbUnifiedOrderCreateReq extends LzccbBaseRequest implements Serializable {

    private static final long serialVersionUID = -2213838555347429210L;


    /**
     * 支付模式：请求方法描述，MZS商户主扫，UZS用户主扫；WXMINAPP 银联微信小程序；
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "method长度不能超过32")
    private String method;

    /**
     * 付款码，商户选择商户主扫此值是必传，最大长度200
     * (特殊必填)
     */
    @Length(max = 200, message = "authCode长度不能超过200")
    private String authCode;

    /**
     * 商户传入业务信息，具体值要和平台约定，应用于安全，营销等参数直传场景，格式为json格式，最大长度200
     * (特殊必填)
     */
    @Length(max = 200, message = "businessParams长度不能超过200")
    private String businessParams;

    /**
     * 可打折金额. 参与优惠计算的金额，单位为元，精确到小数点后两位，取值范围[0.01,100000000] 如果该值未传入，但传入了【订单总金额】，【不可打折金额】则该值默认为【订单总金额】-【不可打折金额】
     * (特殊必填)
     */
    private String discountableAmount;

    /**
     * 商品扩展说明，最大长度100
     * (特殊必填)
     */
    @Length(max = 100, message = "goodsExpandInstruction长度不能超过100")
    private String goodsExpandInstruction;

    /**
     * 商品说明，最大长度100
     * (特殊必填)
     */
    @Length(max = 100, message = "goodsInstruction长度不能超过100")
    private String goodsInstruction;

    /**
     * 商品名称，最大长度100
     * (特殊必填)
     */
    @Length(max = 100, message = "goodsName长度不能超过100")
    private String goodsName;

    /**
     * 商户号，由平台分配（99XXXXXX），最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "merchantNo长度不能超过32")
    private String merchantNo;

    /**
     * 商户通知地址，用于平台主动通知商户地址，最大长度200
     * (必填)
     */
    @NotBlank
    @Length(max = 200, message = "merchantNoticeUrl长度不能超过200")
    private String merchantNoticeUrl;

    /**
     * 支付成功后回调商户页面，最大长度200
     * (特殊必填)
     */
    @Length(max = 200, message = "merchantFrontNoticeUrl长度不能超过200")
    private String merchantFrontNoticeUrl;

    /**
     * 商户操作员编号，最大长度50
     * (特殊必填)
     */
    @Length(max = 50, message = "operatorId长度不能超过50")
    private String operatorId;

    /**
     * 商户订单号,32个字符以内、可包含字母、数字、下划线；需保证在商户端不重复，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "outTradeNo长度不能超过32")
    private String outTradeNo;

    /**
     * 渠道商appid
     */
    private String subAppid;

    /**
     * 商户请求方IP，最大长度15
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "reqIp长度不能超过15")
    private String reqIp;

    /**
     * 商户门店编号(线上支付填写固定值)，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "storeId长度不能超过32")
    private String storeId;

    /**
     * 终端号(POS机具号)(线上支付填写固定值)，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "terminalId长度不能超过32")
    private String terminalId;

    /**
     * 订单总金额，单位为元，精确到小数点后两位，取值范围[0.01,100000000] 如果同时传入了【打折金额】，【不可打折金额】，【订单总金额】三者，则必须满足如下条件：【订单总金额】=【打折金额】+【不可打折金额】 例如：66.88，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "totalAmount长度不能超过32")
    private String totalAmount;

    /**
     * 支付渠道类型：支付宝- AlipayClient（当method=UZS必传）；微信-WeiXIN（当method=UZS或WXMINAPP必传）；银联云闪付-UnionPay（当method=UZS必传）；数字货币-DigitalWallet（当method=UZS必传）；聚合微信支付宝-AllWxAli（只当method=UZS才支持聚合微信支付宝），最大长度32
     * (特殊必填)
     */
    @Length(max = 32, message = "userAgent长度不能超过32")
    private String userAgent;

    /**
     * 终端信息，当method=MZS商户主扫时必传，数据格式：JSON格式字符串，包含location、latitude等多个字段信息
     * (特殊必填)
     */
    private String terminalInfo;

    /**
     * 订单过期时间，单位分钟，最小1分钟，正整数，最大长度12
     * (特殊必填)
     */
    @Length(max = 12, message = "deadline长度不能超过12")
    private String deadline;

    /**
     * 备注，最大长度50
     * (特殊必填)
     */
    @Length(max = 50, message = "remark长度不能超过50")
    private String remark;

}