/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import java.io.Serializable;

/**
 * 订单查询接口 request
 *
 * @author
 * @version LzccbOrderQueryReq.java, v 0.1 2024-09-11 16:37:10
 */
@Data
public class LzccbOrderQueryReq extends LzccbBaseRequest implements Serializable {

    private static final long serialVersionUID = -2213838555212307672L;


    /**
     * 商户号，由平台分配（99XXXXXX），最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "merchantNo长度不能超过32")
    private String merchantNo;

    /**
     * 支付时传入的商户订单号，与tradeNo必填一个
     * (特殊必填)
     */
    private String outTradeNo;

    /**
     * 支付成功时返回的平台订单号，与outTradeNo必填一个
     * (特殊必填)
     */
    private String tradeNo;

    /**
     * 服务商商户号,服务商模式下必传，最大长度32
     * (特殊必填)
     */
    @Length(max = 32, message = "source长度不能超过32")
    private String source;

    /**
     * 订单发起支付日期yyyyMMdd
     * (必填)
     */
    @NotBlank
    private String orderDate;

}