/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import java.io.Serializable;

/**
 * 微信公众号/支付宝H5下单 request
 *
 * @author
 * @version LzccbJsApiPayReq.java, v 0.1 2024-09-11 16:24:45
 */
@Data
public class LzccbJsApiPayReq extends LzccbBaseRequest implements Serializable {

    private static final long serialVersionUID = -2213838555740263960L;


    /**
     * 商户号，由平台分配（99XXXXXX），最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "merchantNo长度不能超过32")
    private String merchantNo;

    /**
     * 支付渠道类型，支付宝 AlipayClient，微信 WeiXIN；，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "userAgent长度不能超过32")
    private String userAgent;

    /**
     * 订单总金额，单位为元，精确到小数点后两位，取值范围[0.01,100000000] 如果同时传入了【打折金额】，【不可打折金额】，【订单总金额】三者，则必须满足如下条件：【订单总金额】=【打折金额】+【不可打折金额】 例如：66.88，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "totalAmount长度不能超过32")
    private String totalAmount;

    /**
     * 支付成功后回调商户页面，最大长度200
     * (特殊必填)
     */
    @Length(max = 200, message = "successUrl长度不能超过200")
    private String successUrl;

    /**
     * 终端号(由运营人员分配)，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "posNum长度不能超过32")
    private String posNum;

    /**
     * 微信用户openId/支付宝用户id，最大长度50
     * (必填)
     */
    @NotBlank
    @Length(max = 50, message = "userId长度不能超过50")
    private String userId;

    /**
     * 商户请求方IP，最大长度15
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "reqIp长度不能超过15")
    private String reqIp;

    /**
     * 商户订单号,32个字符以内、可包含字母、数字、下划线；需保证在商户端不重复，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "outTradeNo长度不能超过32")
    private String outTradeNo;

    /**
     * 渠道商appid
     */
    private String subAppid;

    /**
     * 商户门店编号(线上支付填写固定值)，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "storeNo长度不能超过32")
    private String storeNo;

    /**
     * 备注字段，最大长度50
     * (特殊必填)
     */
    @Length(max = 50, message = "remark长度不能超过50")
    private String remark;

    /**
     * 支付成功后台回调通知地址，最大长度200
     * (特殊必填)
     */
    @Length(max = 200, message = "merchantNoticeUrl长度不能超过200")
    private String merchantNoticeUrl;

}