/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.fshows.response.common.LzccbImpUploadRes;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.io.File;
import java.io.IOException;
import java.util.Map;

/**
 * @author zhoujp
 * @version ILzccbPayUploadPicClientImpl.java, v 0.1 2024-10-10 12:42 zhoujp
 */
@Slf4j
public class LzccbPayUploadPicClientImpl implements ILzccbPayUploadPicClient {


    private String channelNo;

    private String postUrl;

    private String charset;

    public LzccbPayUploadPicClientImpl(String channelNo, String postUrl , String charset) {
        this.channelNo = channelNo;
        this.postUrl = postUrl;
        this.charset = charset;
    }

    @Override
    public LzccbImpUploadRes uploadPic(Map<String, String> parameters, File file) throws FsApiException {
        String responseString = "";
        CloseableHttpClient httpclient = HttpClients.createDefault();
        if (null == parameters || parameters.isEmpty()) {
            return null;
        }

        parameters.put("channelNo", this.channelNo);
        LogUtil.info(log, "【lzccbpay-sdk】图片上传参数 >> parameters ={} ", parameters);
        try {
            HttpPost httpPost = new HttpPost(this.postUrl);
            MultipartEntityBuilder entity = MultipartEntityBuilder.create();
            // 请求参数
            for (String key : parameters.keySet()) {
                entity.addTextBody(key, parameters.get(key), ContentType.DEFAULT_TEXT);
            }
            entity.addPart("file", new FileBody(file));
            httpPost.setEntity(entity.build());
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(50000).setConnectTimeout(30000)
                    .build();// 设置请求和传输超时时间
            httpPost.setConfig(requestConfig);
            LogUtil.info(log, "【lzccbpay-sdk】图片上传入参 >> url={}, param={}, request={} ", this.postUrl, parameters, httpPost.getRequestLine());
            CloseableHttpResponse response = httpclient.execute(httpPost);
            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                HttpEntity httpEntity = response.getEntity();
                log.info("【lzccbpay-sdk】图片上传出参 >> response = " + response.getStatusLine());
                try {
                    if (httpEntity != null) {
                        responseString = EntityUtils.toString(httpEntity);
                        log.info("lzccbpay-sdk 图片上传出参 >> response content:" + responseString);
                        EntityUtils.consume(httpEntity);
                    }
                } finally {
                    response.close();
                }
            }
        } catch (Exception e) {
            log.error("http请求异常", e);
        } finally {
            if (httpclient != null) {
                try {
                    httpclient.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return StrUtil.isBlank(responseString) ? null : JSONObject.parseObject(responseString, LzccbImpUploadRes.class);
    }
}