/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 统一下单接口 response
 *
 * @author
 * @version LzccbUnifiedOrderCreateRes.java, v 0.1 2024-09-10 09:31:48
 */
@Data
@ToString(callSuper = true)
public class LzccbUnifiedOrderCreateRes extends LzccbBaseResponse implements Serializable {

    private static final long serialVersionUID = -2213838555615773047L;

    /**
     * 平台订单号，最大长度32
     * (必填)
     */
    @NotBlank
    private String tradeNo;

    /**
     * 商户号，由平台分配（99XXXXXX），最大长度32
     * (必填)
     */
    @NotBlank
    private String merchantNo;

    /**
     * 商户订单号,32个字符以内、可包含字母、数字、下划线；需保证在商户端不重复，最大长度32
     * (必填)
     */
    @NotBlank
    private String outTradeNo;

    /**
     * 订单总金额，单位为元，精确到小数点后两位，取值范围[0.01,100000000] 如果同时传入了【打折金额】，【不可打折金额】，【订单总金额】三者，则必须满足如下条件：【订单总金额】=【打折金额】+【不可打折金额】 例如：66.88
     * (必填)
     */
    @NotBlank
    private String totalAmount;

    /**
     * 实收金额，在支付成功时返回
     * (必填)
     */
    @NotBlank
    private String receiptAmount;

    /**
     * 交易支付时间(yyyy-MM-dd HH:mm:ss)
     * (必填)
     */
    @NotBlank
    private String gmtPayment;

    /**
     * 用户主扫URL
     * (特殊必填)
     */
    private String codeUrl;

    /**
     * 状态值
     * SUCCESS	交易成功	无
     * PAYING	交易中	发起订单查询
     * UNPAID	待支付/待退款	等待用户付款
     * FAIL	交易失败	交易已经失败，可以重新发起交易
     * CLOASE	交易关闭	交易已经关闭，不能退款
     * (必填)
     */
    @NotBlank
    private String statu;

    /**
     * 状态描述
     * (必填)
     */
    @NotBlank
    private String statuMsg;

}