/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 退款接口 response
 *
 * @author
 * @version LzccbRefundApplyRes.java, v 0.1 2024-09-11 16:37:31
 */
@Data
public class LzccbRefundApplyRes extends LzccbBaseResponse implements Serializable {

    private static final long serialVersionUID = -2213838555326515286L;


    /**
     * 退款下单成功后，平台订单号，最大长度32
     * (必填)
     */
    @NotBlank
    private String tradeNo;

    /**
     * 商户号，由平台分配（99XXXXXX），最大长度32
     * (必填)
     */
    @NotBlank
    private String merchantNo;

    /**
     * 商户订单号,32个字符以内、可包含字母、数字、下划线；需保证在商户端不重复，最大长度32
     * (必填)
     */
    @NotBlank
    private String outTradeNo;

    /**
     * 要退款的金额，该金额不能大于订单金额,单位为元，支持两位小数
     * (必填)
     */
    @NotBlank
    private String refundAmount;

    /**
     * 退款支付时间(yyyy-MM-dd HH:mm:ss)
     * (必填)
     */
    @NotNull
    private String gmtRefundPay;

    /**
     * 状态值
     * (必填)
     */
    @NotBlank
    private String statu;

    /**
     * 状态描述
     * (必填)
     */
    @NotBlank
    private String statuMsg;

}