/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 微信公众号/支付宝H5下单 response
 *
 * @author
 * @version LzccbJsApiPayRes.java, v 0.1 2024-09-11 16:24:46
 */
@Data
@ToString(callSuper = true)
public class LzccbJsApiPayRes extends LzccbBaseResponse implements Serializable {

    private static final long serialVersionUID = -2213838555824465547L;


    /**
     * 平台订单号
     * (必填)
     */
    @NotBlank
    private String trxNo;

    /**
     * 商户订单号,32个字符以内、可包含字母、数字、下划线；需保证在商户端不重复
     * (必填)
     */
    @NotBlank
    private String outTradeNo;

    /**
     * 微信支付宝返回的支付订单号
     * (必填)
     */
    @NotBlank
    private String tradeNo;

}