/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import java.io.Serializable;

/**
 * 退款接口 request
 *
 * @author
 * @version LzccbRefundApplyReq.java, v 0.1 2024-09-11 16:37:31
 */
@Data
public class LzccbRefundApplyReq extends LzccbBaseRequest implements Serializable {

    private static final long serialVersionUID = -2213838555132051129L;


    /**
     * 商户号，由平台分配（99XXXXXX），最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "merchantNo长度不能超过32")
    private String merchantNo;

    /**
     * 商户通知地址，用于平台主动通知商户地址，最大长度200
     * (必填)
     */
    @NotBlank
    @Length(max = 200, message = "merchantNoticeUrl长度不能超过200")
    private String merchantNoticeUrl;

    /**
     * 退款请求订单号，标识一次退款请求，同一笔交易多次退款需要保证唯一，此参数必传，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "outRequestNo长度不能超过32")
    private String outRequestNo;

    /**
     * 订单支付时传入的商户订单号,不能和 tradeNo同时为空，最大长度32
     * (特殊必填)
     */
    @Length(max = 32, message = "outTradeNo长度不能超过32")
    private String outTradeNo;

    /**
     * 要退款的金额，该金额不能大于订单金额,单位为元，支持两位小数
     * (必填)
     */
    @NotBlank
    private String refundAmount;

    /**
     * 退款的原因说明
     * (特殊必填)
     */
    private String refundReason;

    /**
     * 商户门店编号(在线支付写一个固定值)，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "storeId长度不能超过32")
    private String storeId;

    /**
     * 终端号(POS机具号) (在线支付写一个固定值)，最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "terminalId长度不能超过32")
    private String terminalId;

    /**
     * 平台交易流水号，和商户订单号outTradeNo不能同时为空，最大长度32
     * (特殊必填)
     */
    @Length(max = 32, message = "tradeNo长度不能超过32")
    private String tradeNo;

    /**
     * 请求方ip
     * (必填)
     */
    @NotBlank
    private String reqIp;

    /**
     * WeiXIN;AlipayClient;UnionPay;DigitalWallet，原交易的用户客户端
     * (必填)
     */
    @NotBlank
    private String userAgent;

    /**
     * 原交易订单日期yyyyMMdd：建议商户侧该字段必传，若不传，则默认查询三天内订单。
     * (特殊必填)
     */
    private String orderDate;

}