/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import java.io.Serializable;

/**
 * 余额与待清算金额查询接口 request
 *
 * @author
 * @version LzccbBalanceQueryReq.java, v 0.1 2024-09-11 16:41:33
 */
@Data
public class LzccbBalanceQueryReq extends LzccbBaseRequest implements Serializable {

    private static final long serialVersionUID = -2213838555660674952L;


    /**
     * 商户号，由平台分配（99XXXXXX），最大长度32
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "merchantNo长度不能超过32")
    private String merchantNo;

}