package com.fshows.llmcode.web;


import lombok.Data;

/**
 * 客户端请求参数
 *
 * @author
 * @version WebRequest.java, v 0.1 2024-03-14 20:31
 */
@Data
public class WebRequest {

    /**
     * api文本描述
     */
    private String textDesc;

    /**
     * 接口命名
     */
    private String interfaceCode;

    /**
     * request文件输出的绝对路径
     */
    private String requestObjectAbsolutePath;

    /**
     * response文件输出绝对路径
     */
    private String responseObjectAbsolutePath;

    /**
     * 忽略生成的参数列表，例如："merchantId,merchantNo,respCode,respDesc"
     */
    private String ignoreParamList;

    /**
     * request默认前置
     */
    private String requestObjectPrefix;

    /**
     * request默认后置
     */
    private String requestObjectSuffix;

    /**
     * response默认前置
     */
    private String responseObjectPrefix;

    /**
     * response默认后置
     */
    private String responseObjectSuffix;
}
