/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.llmcode.base.model;

import com.fshows.llmcode.base.annotation.DocmentApiField;
import lombok.Data;

/**
 * @author liluqing
 * @version ApiField.java, v 0.1 2022-03-06 20:12
 */
@Data
public class ApiFieldModel {

    /**
     * 字段名
     */
    private String name;

    /**
     * 字段名
     */
    @DocmentApiField(fieldHead = {"名称", "参数", "参数名", "参数名称"})
    private String fieldName;

    /**
     * 格式化后的java字段名称
     */
    private String javaFieldName;

    /**
     * 是否必填 M-必填   C-选填   O-特殊必填
     */
    @DocmentApiField(fieldHead = {"是否必填", "必填", "出现要求"})
    private String must;

    /**
     * 字段类型
     */
    @DocmentApiField(fieldHead = {"类型","类型（最大长度）", "型态"})
    private String fieldType;

    /**
     * 字段详述
     */
    @DocmentApiField(fieldHead = {"描述", "描述信息", "说明"})
    private String description;

    /**
     * 最大长度
     */
    @DocmentApiField(fieldHead = {"最大长度", "长度"})
    private String maxLength;

}