package com.fshows.llmcode.base.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 字段必填枚举
 *
 * @author liluqing
 * @version FieldMustEunm.java, v 0.1 2022-03-16 9:36 liluqing
 */
public enum FieldMustEunm {
    MUST("必填", "必填"),
    M("必填", "M"),
    CONDITION("特殊必填", "C"),
    OPTION("选填", "非必填");

    private String name;
    private String value;

    FieldMustEunm(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static FieldMustEunm getByValue(String value) {
        FieldMustEunm[] valueList = FieldMustEunm.values();
        for (FieldMustEunm v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return OPTION;
    }
}