/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.llmcode.llm;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.dashscope.aigc.generation.Generation;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.models.QwenParam;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.MessageManager;
import com.alibaba.dashscope.common.Role;
import com.alibaba.fastjson.JSONObject;
import com.fshows.llmcode.base.model.ApiModel;
import com.fshows.llmcode.util.LogUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 *
 * @author liluqing
 * @version QwenTest.java, v 0.1 2024-02-14 23:02
 */
@Slf4j
public class QwenLlmRequest {

    /**
     * 密钥
     */
    private final static String API_KEY = "sk-b244dce8f2fe410ca8b2c4a314806fb0";

    /**
     * 通过AI大模型将接口字段描述转化为标准字段模型
     * (请求需在环境变量中配置key, DASHSCOPE_API_KEY=sk-b244dce8f2fe410ca8b2c4a314806fb0)
     * (第一次配置完之后需重启java进程(idea))
     * @return
     */
    public static ApiModel analysisText(String desc) {
        try {
            String filePath = FileUtil.getAbsolutePath("prompt-template.txt");
            String template = FileUtil.readUtf8String(filePath);
            String prompt = StrUtil.format(template, desc);

            Generation gen = new Generation();
            MessageManager msgManager = new MessageManager(10);
            Message systemMsg =
                    Message.builder().role(Role.SYSTEM.getValue()).content("You are a helpful assistant.").build();
            Message userMsg = Message.builder().role(Role.USER.getValue()).content(prompt).build();
            msgManager.add(systemMsg);
            msgManager.add(userMsg);
            QwenParam param =
                    QwenParam.builder().model(Generation.Models.QWEN_TURBO).messages(msgManager.get())
                            .resultFormat(QwenParam.ResultFormat.MESSAGE)
                            .apiKey(API_KEY)
                            .build();
            GenerationResult result = gen.call(param);
            System.out.println(result);
            String content = result.getOutput().getChoices().get(0).getMessage().getContent();
            LogUtil.info(log,"请求AI大模型返回的接口描述信息 >> content >> \n{}", content);
            content = StringUtils.replaceFirst(content, "```json", "");
            content = StringUtils.replace(content, "```", "");
            return JSONObject.parseObject(content, ApiModel.class);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
//        System.out.println(template);
        System.out.println(analysisText("5.4退款\n" +
                "5.4.1发起方  \n" +
                "商户系统\n" +
                "5.4.2业务流程\n" +
                "支持部分退款与全额退款。\n" +
                "微信交易提交退款申请成功后，退款有一定延时，用零钱支付的退款20分钟内到账，银行卡支付的退款3个工作日内到账。\n" +
                "注意：当原交易参与优惠活动时，通道仅支持全额退款。实际情况以通道返回为准。\n" +
                "5.4.3请求报文\n" +
                "序号\t域名\t中文名称\t长度\t必输\t备注\n" +
                "1.\tmerchantId\t一级服务商机构编码\t15\tN\t\n" +
                "字段说明见3.1.10\n" +
                "2.\tmerchantNo\t商户号\t15\tY\t字段说明见3.1.11\n" +
                "3.\trefundOrderNo\t商户退款流水号\t32\tY\t合作方自定义流水号，唯一标识一笔交易（建议根据当前系统日期和时间加随机序列生成，确保唯一 ） \n" +
                "4.\torigOrderNo \t原交易流水号\t32\tY\t需要退款的原交易流水号 \n" +
                "5.\tamount \t退款金额\t10\tY\t单位为元，两位小数，该金额不能大于订单金额\n" +
                "6.\torgPcsDate\t原交易日期\t8\tY\tyyyyMMdd\n" +
                "7.\toccurAdd\t网络地址（终端IP）\t40\tN\tIpv4格式：xx.xx.xx.xx\n" +
                "Ipv6格式：\n" +
                "xx:xx:xx:xx:xx:xx:xx:xx\n" +
                "注:1.Ipv6需转换为16进制;\n" +
                "2.数字人民币退款交易为必填\n" +
                "8.\tGPS\t交易设备GPS\t32\tN\t字段说明见3.1.12。\n" +
                "9.\trefundReason\t退款原因\t128\tN\t填写退款描述，最多64个汉字。数币专用。\n" +
                "不要使用`~!@#$%^&+=|{}';'<>/?~！#￥%&+|{}‘；”“'。？等特殊字符\n" +
                "10.\ttermId\t终端编号\t8\tN\t上送规则如下:\n" +
                "1.上送终端编号为已在我行系统注册的且终端状态启用，上送终端编号应与商户编号相互匹配。\n" +
                "2.条码交易允许跨终端退款，即A终端发生的交易，可以通过B终端发起退款\n" +
                "5.4.4返回报文\n" +
                "返回字段说明：\n" +
                "返回码：“000000”时为退款交易成功。\n" +
                "“10400”时为订单处理中，商户需调用“交易查询”接口查询这笔退款交易最终状态。\n" +
                "序号\t域名\t中文名\t长度\t必填\t说明\t\n" +
                "1.\trespCode\t返回码\t6\tY\t详见数据字典“返回码”\t\n" +
                "2.\trespMsg\t返回信息\t256\tY\t详见数据字典“返回信息”\t\n" +
                "3.\ttradeNo\t平台流水号\t64\tY\t微信、支付宝、银联、数研所等平台返回的退款订单号。\t返回码为“000000”时返回左侧字段。\n" +
                "4.\tsuccessTime \t成功时间\t16\tY\tyyyyMMddHHmmss \t\n" +
                "5.\tchannelOrderNo \t商户通道退款订单号\t50\tY\t银行系统生成，发往微信支付宝银联、数研所通道的通道退款交易订单号\t\n" +
                "6.\tamount\t退款金额\t10\tY\t本次退款金额。\t\n" +
                "7.\torigChannelNo\t原商户通道交易订单号\t50\tY\t需要退款的原商户通道交易订单号\t\n" +
                "8.\tylDctDetail\t银联-商品优惠明细内容\t6000\tN\t详情参见要素说明\t\n" +
                "9.\tylCouponInfo\t银联-优惠信息\t500\tN\t详情参见要素说明\t\n" +
                "10.\twxSettlementRefundFee\t微信-退款金额\t10\tN\t微信-去掉非充值代金券退款金额后的退款金额，退款金额=申请退款金额-非充值代金券退款金额，退款金额<=申请退款金额\t\n" +
                "11.\twxCashRefundFee \t微信-现金退款金额 \t10\tN\t微信-现金退款金额，单位为元 \t\n" +
                "12.\twxCouponRefundFee \t微信-代金券退款总金额 \t10\tN\t微信-代金券退款金额<=退款金额，退款金额-代金券或立减优惠退款金额为现金 \t\n" +
                "13.\twxRefundDetail \t微信-优惠退款详情 \t\tN\t详情参见要素说明\t\n" +
                "14.\taliPresentRefundBuyerAmount\t支付宝-买家退款金额\t10\tN\t支付宝-本次退款金额中买家退款金额\t\n" +
                "15.\taliPresentRefundDiscountAmount\t支付宝-平台优惠退款金额\t10\tN\t支付宝-本次退款金额中平台优惠退款金额\t\n" +
                "16.\taliPresentRefundMdiscountAmount\t支付宝-商家优惠退款金额\t10\tN\t支付宝-本次退款金额中商家优惠退款金额\t"));
    }
}