package com.fshows.llmcode.base.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * api文档参数表格头
 *
 * @author liluqing
 * @version ApiTableTitleEnum.java, v 0.1 2022-03-07 10:57 liluqing
 */
public enum ApiTableTitleEnum {
    REQUEST("请求", "请求报文", "template/requestTemplate.blt"),
    RESPONSE("响应", "响应报文", "template/responseTemplate.blt"),
    ;

    private String name;
    private String value;
    private String template;

    ApiTableTitleEnum(String name, String value, String template) {
        this.name = name;
        this.value = value;
        this.template = template;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    /**
     * Getter method for property <tt>template</tt>.
     *
     * @return property value of template
     */
    public String getTemplate() {
        return template;
    }

    public static ApiTableTitleEnum getByValue(String value) {
        ApiTableTitleEnum[] valueList = ApiTableTitleEnum.values();
        for (ApiTableTitleEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}