/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.riskcore.facade.enums;

import cn.hutool.core.util.ObjectUtil;

public enum RiskMerchantChannelEnum {
    SDWX("sdwx", "\u6749\u5fb7\u5fae\u4fe1", 12),
    SXPAY("sxpay", "\u968f\u884c\u4ed8", 15),
    SDSBWX("sdsbwx", "\u6749\u5fb7\u6536\u5457\u5fae\u4fe1", 18),
    LESHUA("leshua", "\u4e50\u5237", 21),
    UMPAY("umpay", "\u8054\u52a8", 26);

    private String code;
    private String name;
    private Integer liquidationType;

    private RiskMerchantChannelEnum(String code, String name, Integer liquidationType) {
        this.code = code;
        this.name = name;
        this.liquidationType = liquidationType;
    }

    public static RiskMerchantChannelEnum getByCode(String code) {
        RiskMerchantChannelEnum[] values;
        for (RiskMerchantChannelEnum value : values = RiskMerchantChannelEnum.values()) {
            if (!value.getCode().equals(code)) continue;
            return value;
        }
        return null;
    }

    public static Integer getLiquidationTypeByCode(String code) {
        RiskMerchantChannelEnum merchantChannelEnum = RiskMerchantChannelEnum.getByCode(code);
        if (ObjectUtil.isNull((Object)((Object)merchantChannelEnum))) {
            return null;
        }
        return merchantChannelEnum.getLiquidationType();
    }

    public static RiskMerchantChannelEnum getByLiquidationType(Integer liquidationType) {
        RiskMerchantChannelEnum[] values;
        for (RiskMerchantChannelEnum value : values = RiskMerchantChannelEnum.values()) {
            if (!value.getLiquidationType().equals(liquidationType)) continue;
            return value;
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Integer getLiquidationType() {
        return this.liquidationType;
    }
}

