/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.riskcore.facade.enums;

import com.google.common.collect.Maps;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MerchantTypeEnum {
    PERSONAL_MERCHANT("\u6d93\ue043\u6c49\u935f\u55d8\u57db", 1),
    COMPANY_MERCHANT("\u6d7c\u4f77\u7b1f\u935f\u55d8\u57db", 2),
    FOREIGNER_MERCHANT("\u5a13\ue21b\u5883\u9359\u677f\u5f37\u6fb6\u682b\u7744\u935f\u55d8\u57db", 3);

    public static final Map<Integer, String> map;
    private final String name;
    private final Integer value;

    private MerchantTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public static MerchantTypeEnum getByValue(Integer value) {
        MerchantTypeEnum[] valueList;
        for (MerchantTypeEnum v : valueList = MerchantTypeEnum.values()) {
            if (!v.getValue().equals(value)) continue;
            return v;
        }
        return null;
    }

    public static String valueOf(Integer value) {
        MerchantTypeEnum[] valueList;
        for (MerchantTypeEnum v : valueList = MerchantTypeEnum.values()) {
            if (!v.value.equals(value)) continue;
            return v.name;
        }
        return "";
    }

    public String getName() {
        return this.name;
    }

    public Integer getValue() {
        return this.value;
    }

    static {
        map = Maps.newLinkedHashMapWithExpectedSize((int)10);
        for (MerchantTypeEnum typeEnum : MerchantTypeEnum.values()) {
            map.put(typeEnum.value, typeEnum.name);
        }
    }
}

