/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.liquidationcore.facade.enums.fuiou;

import cn.hutool.core.collection.CollUtil;
import com.fshows.lifecircle.liquidationcore.facade.enums.common.TradeStateEnum;
import com.google.common.collect.Lists;
import java.util.List;

public enum FuiouTransStatEnum {
    SUCCESS("\u6210\u529f", "SUCCESS", Lists.newArrayList((Object[])new String[]{"1"}), TradeStateEnum.TRADE_SUCCESS),
    PAY_ERROR("\u5931\u8d25", "PAYERROR", Lists.newArrayList((Object[])new String[]{"5"}), TradeStateEnum.TRADE_FAIL),
    USER_PAYING("\u652f\u4ed8\u4e2d", "USERPAYING", Lists.newArrayList((Object[])new String[]{"6"}), TradeStateEnum.TRADE_PAYING),
    NOT_PAY("\u672a\u652f\u4ed8", "NOTPAY", null, TradeStateEnum.TRADE_PAYING),
    CLOSED("\u5df2\u5173\u95ed", "CLOSED", null, TradeStateEnum.TRADE_CLOSED),
    REVOKED("\u5df2\u64a4\u9500", "REVOKED", Lists.newArrayList((Object[])new String[]{"3", "4"}), TradeStateEnum.TRADE_CANCELED),
    REFUND("\u5df2\u9000\u6b3e", "REFUND", Lists.newArrayList((Object[])new String[]{"2"}), TradeStateEnum.REFUND_SUCCESS);

    private final String name;
    private final String value;
    private final List<String> bankPayValueList;
    private final TradeStateEnum tradeStateEnum;

    private FuiouTransStatEnum(String name, String value, List<String> bankPayValueList, TradeStateEnum tradeStateEnum) {
        this.name = name;
        this.value = value;
        this.bankPayValueList = bankPayValueList;
        this.tradeStateEnum = tradeStateEnum;
    }

    public static FuiouTransStatEnum getByValue(String value) {
        for (FuiouTransStatEnum v : FuiouTransStatEnum.values()) {
            if (!v.getValue().equalsIgnoreCase(value)) continue;
            return v;
        }
        return null;
    }

    public static FuiouTransStatEnum getByBankPayValue(String bankPayValue) {
        for (FuiouTransStatEnum v : FuiouTransStatEnum.values()) {
            if (!CollUtil.isNotEmpty(v.getBankPayValueList()) || !v.getBankPayValueList().contains(bankPayValue)) continue;
            return v;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public List<String> getBankPayValueList() {
        return this.bankPayValueList;
    }

    public TradeStateEnum getTradeStateEnum() {
        return this.tradeStateEnum;
    }
}

